/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.moncompare.Condition;
import org.appwork.moncompare.Scope;
import org.appwork.moncompare.fromjson.FlexiCondition;
import org.appwork.storage.BuildsInfo;
import org.appwork.storage.FailLevel;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDeprecatedSince;
import org.appwork.storage.StorableHidden;
import org.appwork.storage.StorableValidateCondition;
import org.appwork.storage.StorableValidateCondition2;
import org.appwork.storage.StorableValidateCondition3;
import org.appwork.storage.StorableValidateMandatoryInJson;
import org.appwork.storage.StorableValidateNotNull;
import org.appwork.storage.StorableValidateRegex;
import org.appwork.storage.StorableValidateTimeSpan;
import org.appwork.storage.StorableValidateTimestamp;
import org.appwork.storage.StorableValidateTimestampRelative;
import org.appwork.storage.StorableValidationLogic;
import org.appwork.storage.StorableValidatorIgnoreKey;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.CannotResolvePathException;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiJsonMapperForConfig;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.InvalidPathException;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.NodeFilter;
import org.appwork.storage.flexijson.mapper.ClassCastFlexiMapperException;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiKeyLookup;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.FlexiTypeMapper;
import org.appwork.storage.flexijson.mapper.typemapper.DateMapper;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyPrinterForConfig;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.simplejson.ValueType;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Property;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.storage.validator.classvalidator.StorableAbstractValidator;
import org.appwork.storage.validator.classvalidator.StorableClassValidator1;
import org.appwork.storage.validator.classvalidator.StorableClassValidator2;
import org.appwork.storage.validator.classvalidator.StorableClassValidator3;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.reflection.CompiledType;

public class StorableValidator<T> {
    private FlexiJSonNode rootNode;
    private CompiledType rootType;
    private T result;
    private ArrayList<ValidatetoDoss> toDos;
    private ArrayList<ValidatorException> exceptions;
    private String targetBuildsProperty = "targetBuilds";

    protected void add(FlexiMapperException ex) {
        if (ex instanceof ValidatorException) {
            this.exceptions.add((ValidatorException)ex);
        } else {
            this.exceptions.add(new ValidatorException(this, ex, JSPath.fromFlexiNode(ex.node), ex.node, ex.type, null, FailLevel.ERROR));
        }
    }

    public CompiledType dynamicTypeMapping(FlexiJSonNode json, CompiledType type, Setter setter) {
        return type;
    }

    public CompiledType getRootType() {
        return this.rootType;
    }

    public String getTargetBuildsProperty() {
        return this.targetBuildsProperty;
    }

    public void setTargetBuildsProperty(String targetBuildsProperty) {
        this.targetBuildsProperty = targetBuildsProperty;
    }

    public StorableValidator(FlexiJSonNode node, TypeRef<T> type) {
        this(node, CompiledType.create(type.getType()));
    }

    public StorableValidator(FlexiJSonNode node, CompiledType type) {
        this.rootNode = node;
        this.rootType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ValidatorException> validate() {
        this.toDos = new ArrayList();
        this.exceptions = new ArrayList();
        CheckerMapper mapper = this.createMapper();
        this.extendMapper(mapper);
        try {
            FlexiJSonNode extended = this.rootNode;
            this.result = mapper.jsonToObject(extended, this.rootType);
            HashMap<String, Condition.PathHandler> customPathhandlers = new HashMap<String, Condition.PathHandler>();
            customPathhandlers.put("\u00a7nondefaults", new Condition.PathHandler(){

                @Override
                public Scope resolve(Scope oldScope, Scope scope, Object key) {
                    FlexiJSonMapper mapper = new FlexiJSonMapper();
                    mapper.setIgnoreDefaultValuesEnabled(true);
                    try {
                        FlexiJSonNode newValue = mapper.objectToJsonNode(scope.getLast());
                        if (newValue instanceof FlexiJSonArray) {
                            scope.add(mapper.jsonToObject(newValue, TypeRef.OBJECT_ARRAY), key);
                            return scope;
                        }
                        scope.add(mapper.jsonToObject(newValue, TypeRef.OBJECT), key);
                        return scope;
                    }
                    catch (FlexiMapperException e) {
                        throw new WTFException(e);
                    }
                }
            });
            customPathhandlers.put("\u00a7node", new Condition.PathHandler(){

                @Override
                public Scope resolve(Scope oldScope, Scope scope, Object key) {
                    JSPath path = scope.getPath();
                    LinkedList<Object> elements = new LinkedList<Object>(path.getElements());
                    if ("\u00a7\u00a7THIS".equals(elements.removeFirst())) {
                        FlexiJSonNode targetNode = StorableValidator.this.rootNode.resolvePath(JSPath.fromPathElements(elements.toArray(new Object[0])));
                        scope.add(targetNode, key);
                        return scope;
                    }
                    throw new WTFException("Path not supported");
                }
            });
            customPathhandlers.put(null, new Condition.PathHandler(){

                @Override
                public Scope resolve(Scope oldScope, Scope scope, Object key) {
                    if (key instanceof String && "\u00a7type".equalsIgnoreCase((String)key)) {
                        if (scope.getLast() instanceof FlexiJSonObject) {
                            scope.add("OBJECT", key);
                            return scope;
                        }
                        if (scope.getLast() instanceof FlexiJSonArray) {
                            scope.add("ARRAY", key);
                            return scope;
                        }
                        if (scope.getLast() instanceof FlexiJSonValue) {
                            scope.add(((FlexiJSonValue)scope.getLast()).getType().name(), key);
                            return scope;
                        }
                    }
                    if (key instanceof String && ((String)key).startsWith("\u00a7")) {
                        return null;
                    }
                    if (scope.getLast() instanceof FlexiJSonObject) {
                        scope.add(((FlexiJSonObject)scope.getLast()).getNode(String.valueOf(key)), key);
                        return scope;
                    }
                    if (scope.getLast() instanceof FlexiJSonArray) {
                        scope.add(((FlexiJSonArray)scope.getLast()).get(((Number)key).intValue()), key);
                        return scope;
                    }
                    return null;
                }
            });
            Map<String, Condition.PathHandler> before = Condition.PATH_HANDLERS.get();
            try {
                Condition.PATH_HANDLERS.set(customPathhandlers);
                this.run(this.result, extended, this.rootType, new JSPath(), null);
            }
            finally {
                Condition.PATH_HANDLERS.set(before);
            }
        }
        catch (ClassCastFlexiMapperException e) {
            this.add(new InvalidTypeException(this, JSPath.fromFlexiNode(e.node), e.node, e.type, e.getMessage(), FailLevel.ERROR));
        }
        catch (FlexiMapperException e) {
            this.add(e);
        }
        return this.exceptions;
    }

    private void run(Object object, FlexiJSonNode node, CompiledType type, JSPath path, Property context) {
        block20: {
            block22: {
                block21: {
                    ValidatetoDoss todo = new ValidatetoDoss(node, object, type, context, path);
                    if (type.hasAnnotation(StorableHidden.class)) {
                        return;
                    }
                    if (context != null) {
                        if (context.getter.classCache.getAnnotations(context.key, StorableValidatorIgnoreKey.class).size() > 0) {
                            return;
                        }
                        if (context.getter.classCache.getAnnotations(context.key, StorableHidden.class).size() > 0) {
                            return;
                        }
                    }
                    this.validateToDo(todo);
                    if (type.isInstanceOf(new Type[]{TimeSpan.class, Date.class}) && node instanceof FlexiJSonValue || type.isPrimitive() || type.isString() || type.isObject()) break block20;
                    if (!type.isMap()) break block21;
                    if (!(node instanceof FlexiJSonObject)) {
                        return;
                    }
                    if (object == null) {
                        return;
                    }
                    for (KeyValueElement e : ((FlexiJSonObject)node).getElements()) {
                        Object newObject = ((Map)object).get(e.getKey());
                        JSPath newPath = path.derive(e.getKey());
                        FlexiJSonNode newNode = e.getValue();
                        this.run(newObject, newNode, type.getComponentTypeFor(Map.class), newPath, null);
                    }
                    break block20;
                }
                if (!type.isListContainer()) break block22;
                if (!(node instanceof FlexiJSonArray)) {
                    return;
                }
                if (object == null) {
                    return;
                }
                List<Object> values = type.getListElements(object);
                for (int i = 0; i < values.size(); ++i) {
                    Object newObject = values.get(i);
                    JSPath newPath = path.derive(i);
                    FlexiJSonNode newNode = (FlexiJSonNode)((FlexiJSonArray)node).get(i);
                    this.run(newObject, newNode, type.getComponentTypeFor(Array.class, Collection.class), newPath, null);
                }
                break block20;
            }
            if (type.isEnum(true)) break block20;
            if (!(node instanceof FlexiJSonObject)) {
                return;
            }
            if (object == null) {
                return;
            }
            ClassCache cc = type.getClassCache();
            Set<String> keys = ((FlexiJSonObject)node).getKeys();
            for (String key : cc.getKeys()) {
                keys.remove(key);
                Property property = cc.getProperty(key);
                JSPath newPath = path.derive(key);
                try {
                    Object newObject = property.getter.getValue(object);
                    FlexiJSonNode newNode = ((FlexiJSonObject)node).getNode(key);
                    CompiledType newType = null;
                    newType = type.resolve(JSPath.fromPathString(key));
                    this.run(newObject, newNode, newType, newPath, property);
                }
                catch (IllegalArgumentException e) {
                    throw new WTFException(e);
                }
                catch (IllegalAccessException e) {
                    throw new WTFException(e);
                }
                catch (InvocationTargetException e) {
                    throw new WTFException(e);
                }
                catch (CannotResolvePathException e) {
                    throw new WTFException(e);
                }
                catch (InvalidPathException e) {
                    throw new WTFException(e);
                }
            }
            for (String key : keys) {
                FlexiJSonNode subNode = ((FlexiJSonObject)node).resolvePath(JSPath.fromPathElements(key));
                this.add(new UnknownPropertyException(this, path.derive(key), subNode, null));
            }
        }
    }

    public void scanType(CompiledType orgType) {
        CompiledType type = orgType;
        ClassCache cc = type.getClassCache();
        for (String key : type.getClassCache().getKeys()) {
            Property property = type.getClassCache().getProperty(key);
        }
    }

    protected CheckerMapper createMapper() {
        return new CheckerMapper();
    }

    protected void extendMapper(FlexiJSonMapper mapper) {
    }

    public T getResult() {
        return this.result;
    }

    protected void validateToDo(ValidatetoDoss toDo) {
        for (Annotation c : toDo.annotations) {
            try {
                Comparable<TimeSpan> value;
                Annotation condition;
                if (c instanceof StorableDeprecatedSince && toDo.node != null) {
                    condition = (StorableDeprecatedSince)c;
                    if (this.rootNode instanceof FlexiJSonObject && ((FlexiJSonObject)this.rootNode).resolvePath(toDo.path) == null) {
                        DebugMode.debugger();
                        continue;
                    }
                    String desc = condition.message();
                    long ts = ((Date)new DateMapper().json2Obj(null, new FlexiJSonValue(condition.value()), CompiledType.create(Date.class), null)).getTime();
                    BuildsInfo buildInfo = this.getTargetBuildsinfo(toDo.node);
                    desc = StringUtils.isEmpty(desc) ? "[Deprecated since " + DateFormat.getDateTimeInstance(1, 2).format(ts) + "]" : "[Deprecated since " + DateFormat.getDateTimeInstance(1, 2).format(ts) + "] " + desc;
                    DeprecatedException ex = new DeprecatedException(this, ts, toDo.path, toDo.node, toDo.type, desc, condition.level());
                    if (buildInfo != null && ex.handle(buildInfo) == BuildsInfo.TargetBuildIssue.NO_TARGET_BUILDS_AFFECTED) continue;
                    this.add(ex);
                }
                if (c instanceof StorableAvailableSince && toDo.node != null) {
                    condition = (StorableAvailableSince)c;
                    String path = FlexiUtils.getPathString(toDo.node);
                    if (this.rootNode instanceof FlexiJSonObject && ((FlexiJSonObject)this.rootNode).resolvePath(path) == null) continue;
                    String desc = condition.message();
                    long ts = ((Date)new DateMapper().json2Obj(null, new FlexiJSonValue(condition.value()), CompiledType.create(Date.class), null)).getTime();
                    desc = StringUtils.isEmpty(desc) ? "[Available since " + DateFormat.getDateTimeInstance(1, 2).format(new Date(ts)) + "]" : "[Available since " + DateFormat.getDateTimeInstance(1, 2).format(new Date(ts)) + "] " + desc;
                    BuildsInfo buildInfo = this.getTargetBuildsinfo(toDo.node);
                    AvailableSinceException ex = new AvailableSinceException(this, ts, toDo.path, toDo.node, toDo.type, desc, condition.level());
                    if (buildInfo != null && ex.handle(buildInfo) == BuildsInfo.TargetBuildIssue.NO_TARGET_BUILDS_AFFECTED) continue;
                    this.add(ex);
                }
                if (c instanceof StorableValidateTimestampRelative) {
                    condition = (StorableValidateTimestampRelative)c;
                    if (!(toDo.node instanceof FlexiJSonValue)) {
                        this.add(new InvalidTypeException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                        continue;
                    }
                    value = (Date)new FlexiJSonMapper().jsonToObject(toDo.node, CompiledType.create(Date.class));
                    if (value == null) {
                        this.add(new NullException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                        continue;
                    }
                    long max = System.currentTimeMillis() + condition.max();
                    long min = System.currentTimeMillis() + condition.min();
                    if (((Date)value).getTime() >= min && ((Date)value).getTime() <= max) continue;
                    this.add(new InvalidTimestampException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level(), min, max, ((Date)value).getTime()));
                }
                if (c instanceof StorableValidateTimestamp) {
                    long min;
                    condition = (StorableValidateTimestamp)c;
                    if (!(toDo.node instanceof FlexiJSonValue)) {
                        this.add(new InvalidTypeException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                        continue;
                    }
                    value = (Date)new FlexiJSonMapper().jsonToObject(toDo.node, CompiledType.create(Date.class));
                    if (value == null) {
                        this.add(new NullException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                        continue;
                    }
                    long now = System.currentTimeMillis();
                    long max = condition.max();
                    if (max == -1L) {
                        max = now;
                    }
                    if ((min = condition.min()) == -1L) {
                        min = now;
                    }
                    if (((Date)value).getTime() >= min && ((Date)value).getTime() <= max) continue;
                    this.add(new InvalidTimestampException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level(), min, max, ((Date)value).getTime()));
                }
                if (c instanceof StorableValidateTimeSpan) {
                    condition = (StorableValidateTimeSpan)c;
                    value = (TimeSpan)toDo.value;
                    if (value == null) {
                        this.add(new NullException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                        continue;
                    }
                    TimeSpan max = null;
                    TimeSpan min = null;
                    if (StringUtils.isNotEmpty(condition.max()) && !(max = TimeSpan.parse(condition.max())).hasContext()) {
                        max = max.withStaticContext(365.0);
                    }
                    if (StringUtils.isNotEmpty(condition.min()) && !(min = TimeSpan.parse(condition.min())).hasContext()) {
                        min = min.withStaticContext(365.0);
                    }
                    if (((TimeSpan)value).withFallbackContext(max).isMoreThan(max)) {
                        this.add(new ValidatorInvalidTimeSpanException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level(), min, max, (TimeSpan)value));
                    }
                    if (((TimeSpan)value).withFallbackContext(min).isLessThan(min)) {
                        this.add(new ValidatorInvalidTimeSpanException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level(), min, max, (TimeSpan)value));
                    }
                }
                if (c instanceof StorableValidateRegex) {
                    condition = (StorableValidateRegex)c;
                    if (toDo.node != null && ((FlexiJSonValue)toDo.node).getType() != ValueType.STRING && ((FlexiJSonValue)toDo.node).getType() != ValueType.NULL) {
                        this.add(new InvalidTypeException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                        continue;
                    }
                    if (toDo.value == null) {
                        if (condition.nullAllowed()) {
                            return;
                        }
                        this.add(new NullException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                    } else if (StringUtils.isEmpty((String)toDo.value) && !condition.nullAllowed()) {
                        this.add(new EmptyStringException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                    } else {
                        try {
                            Pattern.compile((String)toDo.value);
                        }
                        catch (Exception e) {
                            this.add(new InvalidRegularExpressionException(this, toDo.path, toDo.node, toDo.type, condition.message(), condition.level()));
                        }
                    }
                }
                if (c instanceof StorableValidateMandatoryInJson) {
                    this.validateMandatory(toDo, (StorableValidateMandatoryInJson)c);
                }
                if (c instanceof StorableClassValidator1) {
                    this.validateClassValidator(toDo, ((StorableClassValidator1)c).cls(), ((StorableClassValidator1)c).parameter(), ((StorableClassValidator1)c).level(), ((StorableClassValidator1)c).message());
                }
                if (c instanceof StorableClassValidator2) {
                    this.validateClassValidator(toDo, ((StorableClassValidator2)c).cls(), ((StorableClassValidator2)c).parameter(), ((StorableClassValidator2)c).level(), ((StorableClassValidator2)c).message());
                }
                if (c instanceof StorableClassValidator3) {
                    this.validateClassValidator(toDo, ((StorableClassValidator3)c).cls(), ((StorableClassValidator3)c).parameter(), ((StorableClassValidator3)c).level(), ((StorableClassValidator3)c).message());
                }
                if (c instanceof StorableValidateNotNull) {
                    this.validateNotNull(toDo, (StorableValidateNotNull)c);
                }
                if (c instanceof StorableValidateCondition) {
                    condition = (StorableValidateCondition)c;
                    this.validateCondition(toDo, condition.value(), condition.level(), condition.logic(), condition.description());
                }
                if (c instanceof StorableValidateCondition2) {
                    condition = (StorableValidateCondition2)c;
                    this.validateCondition(toDo, condition.value(), condition.level(), condition.logic(), condition.description());
                }
                if (!(c instanceof StorableValidateCondition3)) continue;
                condition = (StorableValidateCondition3)c;
                this.validateCondition(toDo, condition.value(), condition.level(), condition.logic(), condition.description());
            }
            catch (Exception e) {
                this.add(new ValidatorException(this, e, toDo.path, toDo.node, toDo.type, null, FailLevel.ERROR));
            }
        }
    }

    private FlexiJSonObject getTargetBuildsNode(FlexiJSonNode node) {
        while (node != null) {
            FlexiJSonNode targetBuilds;
            if (node instanceof FlexiJSonObject && (targetBuilds = ((FlexiJSonObject)node).getNode(this.getTargetBuildsProperty())) != null && targetBuilds instanceof FlexiJSonObject) {
                return (FlexiJSonObject)targetBuilds;
            }
            node = node.getParent();
        }
        return null;
    }

    private BuildsInfo getTargetBuildsinfo(FlexiJSonNode node) throws FlexiMapperException {
        FlexiJSonObject ret = this.getTargetBuildsNode(node);
        if (ret != null) {
            return this.createMapper().jsonToObject((FlexiJSonNode)ret, BuildsInfo.TYPE);
        }
        return null;
    }

    private void validateClassValidator(ValidatetoDoss toDo, Class<? extends StorableAbstractValidator> cls, String parameter, FailLevel level, String message) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException {
        List<? extends ValidatorException> toadd = cls.newInstance().validate(this, this.result, toDo.value, toDo.node, toDo.path, toDo.type, parameter, level, message);
        if (toadd != null) {
            for (ValidatorException validatorException : toadd) {
                this.add(validatorException);
            }
        }
    }

    private void validateNotNull(ValidatetoDoss toDo, StorableValidateNotNull a) {
        try {
            Condition<T> c = new Condition<T>(toDo.path.withPrefix("\u00a7\u00a7THIS").toPathString(true), FlexiCondition.parse("{$ne:null}", true, Condition.class));
            boolean result = c.matches(this.result);
            if (!result) {
                this.add(new ValidatorValueIsNullException(this, toDo.path, toDo.node, toDo.type, a));
            }
        }
        catch (Exception e) {
            throw new WTFException(e);
        }
    }

    private void validateMandatory(ValidatetoDoss toDo, StorableValidateMandatoryInJson a) {
        if (toDo.node != null) {
            return;
        }
        this.add(new ValidatorMandatoryPropertyMissingException(this, toDo.type, toDo.path, a));
    }

    private void validateCondition(ValidatetoDoss toDo, String value, FailLevel level, StorableValidationLogic logic, String desc) {
        if (StringUtils.isEmpty(desc)) {
            switch (logic) {
                case FAIL_ON_MATCH: {
                    desc = "Must not match the condition " + value;
                    break;
                }
                default: {
                    desc = "Must match the condition " + value;
                }
            }
        }
        try {
            Condition condition = FlexiCondition.parse(value, true, Condition.class);
            Condition options = (Condition)condition.get("\u00a7options");
            if (options == null) {
                options = new Condition();
            }
            options.put("filterRoot", (Object)true);
            condition.put("\u00a7options", (Object)options);
            Condition<T> c = new Condition<T>(toDo.path.withPrefix("\u00a7\u00a7THIS").toPathString(true), condition);
            boolean result = c.matches(this.result);
            if (!result && logic == StorableValidationLogic.OK_ON_MATCH || result && logic == StorableValidationLogic.FAIL_ON_MATCH) {
                this.add(new ConditionException(this, c, toDo.path, toDo.node, toDo.type, desc, level));
            }
        }
        catch (Exception e) {
            LogV3.warning("Bad Validation Condition: " + this.result.getClass() + ":\r\n" + value);
            LogV3.log(e);
            this.add(new ConditionException(this, null, e, toDo.path, toDo.node, toDo.type, "Invalid Condition: " + Exceptions.getStackTrace(e), level));
        }
    }

    class ValidatetoDoss {
        private FlexiJSonNode node;
        private Object value;
        private CompiledType type;
        private List<Annotation> annotations = new ArrayList<Annotation>();
        private JSPath path;

        private void add(List<? extends Annotation> a) {
            if (a != null && a.size() > 0) {
                this.annotations.addAll(a);
            }
        }

        public ValidatetoDoss(FlexiJSonNode node, Object value, CompiledType type, Property context, JSPath path) {
            this.node = node;
            this.path = path;
            this.value = value;
            this.type = type;
            ClassCache cc = type.getClassCache();
            if (value != null) {
                this.add(cc.getAnnotations(null, StorableClassValidator1.class));
                this.add(cc.getAnnotations(null, StorableClassValidator2.class));
                this.add(cc.getAnnotations(null, StorableClassValidator3.class));
                this.add(cc.getAnnotations(null, StorableValidateNotNull.class));
                this.add(cc.getAnnotations(null, StorableValidateMandatoryInJson.class));
                this.add(cc.getAnnotations(null, StorableValidateCondition.class));
                this.add(cc.getAnnotations(null, StorableValidateCondition2.class));
                this.add(cc.getAnnotations(null, StorableValidateCondition3.class));
                this.add(cc.getAnnotations(null, StorableValidateRegex.class));
                this.add(cc.getAnnotations(null, StorableDeprecatedSince.class));
                this.add(cc.getAnnotations(null, StorableAvailableSince.class));
                this.add(cc.getAnnotations(null, StorableValidateTimestamp.class));
                this.add(cc.getAnnotations(null, StorableValidateTimestampRelative.class));
                this.add(cc.getAnnotations(null, StorableValidateTimeSpan.class));
            }
            if (context != null) {
                cc = context.getter.classCache;
                this.add(cc.getAnnotations(context.key, FlexiKeyLookup.class));
                this.add(cc.getAnnotations(context.key, StorableClassValidator1.class));
                this.add(cc.getAnnotations(context.key, StorableClassValidator2.class));
                this.add(cc.getAnnotations(context.key, StorableClassValidator3.class));
                this.add(cc.getAnnotations(context.key, StorableValidateNotNull.class));
                this.add(cc.getAnnotations(context.key, StorableValidateMandatoryInJson.class));
                this.add(cc.getAnnotations(context.key, StorableValidateCondition.class));
                this.add(cc.getAnnotations(context.key, StorableValidateCondition2.class));
                this.add(cc.getAnnotations(context.key, StorableValidateCondition3.class));
                this.add(cc.getAnnotations(context.key, StorableValidateRegex.class));
                this.add(cc.getAnnotations(context.key, StorableDeprecatedSince.class));
                this.add(cc.getAnnotations(context.key, StorableAvailableSince.class));
                this.add(cc.getAnnotations(context.key, StorableValidateTimestamp.class));
                this.add(cc.getAnnotations(context.key, StorableValidateTimestampRelative.class));
                this.add(cc.getAnnotations(context.key, StorableValidateTimeSpan.class));
            }
        }
    }

    public static class InvalidTypeException
    extends ValidatorException {
        public InvalidTypeException(StorableValidator validator, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, path, value, targetType, message, failLevel);
        }

        @Override
        public String getErrorMessage() {
            if (this.getMessage() != null) {
                return this.getMessage();
            }
            String ret = "";
            if (this.node instanceof FlexiJSonValue) {
                String typeName = this.type.toString();
                if (this.type.raw instanceof Class) {
                    typeName = this.type.raw.getSimpleName();
                }
                ret = ret + "Invalid type! Cannot map " + new FlexiJSonStringBuilder().toJSONString(this.node) + "(" + (Object)((Object)((FlexiJSonValue)this.node).getType()) + ") to type " + typeName + ".";
                try {
                    ret = ret + " \r\nTry this instead: " + FlexiUtils.serializeToPrettyJson(new FlexiJSonMapper().jsonToObject(this.node, new SimpleTypeRef(this.type.type))) + "";
                }
                catch (FlexiMapperException flexiMapperException) {}
            } else {
                ret = this.node instanceof FlexiJSonArray ? ret + "Invalid type! Cannot map an array [...] to type " + this.type + "." : ret + "Invalid type! Cannot map an object {...} to type " + this.type + ".";
            }
            return ret;
        }
    }

    public static class EmptyStringException
    extends ValidatorException {
        public EmptyStringException(StorableValidator validator, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, path, value, targetType, message, failLevel);
        }

        @Override
        public String getErrorMessage() {
            if (this.getMessage() != null) {
                return this.getMessage();
            }
            return "An empty string is not allowed for this property";
        }
    }

    public static class NullException
    extends ValidatorException {
        public NullException(StorableValidator validator, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, path, value, targetType, message, failLevel);
        }

        @Override
        public String getErrorMessage() {
            if (this.getMessage() != null) {
                return this.getMessage();
            }
            return "null is not allowed for this property";
        }
    }

    public static class DeprecatedException
    extends ValidatorException {
        public final long deprecatedSinceTimestamp;

        public DeprecatedException(StorableValidator validator, long deprecatedSince, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel level) {
            super(validator, path, value, targetType, message, level);
            this.deprecatedSinceTimestamp = deprecatedSince;
        }

        @Override
        public String getErrorMessage() {
            if (this.getMessage() != null) {
                return this.getMessage();
            }
            return "Property deprecated since " + DateFormat.getDateTimeInstance(1, 2).format(new Date(this.deprecatedSinceTimestamp));
        }

        public BuildsInfo.TargetBuildIssue handle(BuildsInfo buildsInfo) {
            Date minimum = buildsInfo.getMinimumBuildDate();
            if (minimum != null && minimum.getTime() < this.deprecatedSinceTimestamp) {
                return BuildsInfo.TargetBuildIssue.ALL_TARGET_BUILDS_AFFECTED;
            }
            Date maximum = buildsInfo.getMaximumBuildDate();
            if (maximum != null && this.deprecatedSinceTimestamp < maximum.getTime()) {
                return BuildsInfo.TargetBuildIssue.SOME_TARGET_BUILDS_AFFECTED;
            }
            return BuildsInfo.TargetBuildIssue.NO_TARGET_BUILDS_AFFECTED;
        }
    }

    public static class ValidatorValueIsNullException
    extends ValidatorException {
        public final StorableValidateNotNull annotation;
        public final JSPath path;

        public ValidatorValueIsNullException(StorableValidator storableValidator, JSPath path, FlexiJSonNode node, CompiledType type, StorableValidateNotNull a) {
            super(storableValidator, path, node, type, StringUtils.isEmpty(a.description()) ? "The property " + path.getLast() + " must not be null!" : a.description(), a.level());
            this.annotation = a;
            this.path = path;
        }

        public ValidatorValueIsNullException(StorableValidator storableValidator, JSPath path, FlexiJSonNode node, CompiledType type, String message, FailLevel level) {
            super(storableValidator, path, node, type, message, level);
            this.annotation = null;
            this.path = path;
        }
    }

    public static class ValidatorMandatoryPropertyMissingException
    extends ValidatorException {
        public final StorableValidateMandatoryInJson annotation;

        public ValidatorMandatoryPropertyMissingException(StorableValidator storableValidator, CompiledType type, JSPath path, StorableValidateMandatoryInJson a) {
            super(storableValidator, path, null, type, StringUtils.isEmpty(a.message()) ? "The property " + path.getLast() + " must be set!" : a.message(), a.level());
            this.annotation = a;
        }
    }

    public static class ValidatorInvalidTimeSpanException
    extends ValidatorException {
        public final TimeSpan min;
        public final TimeSpan max;
        public final TimeSpan value;

        public ValidatorInvalidTimeSpanException(StorableValidator validator, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel, TimeSpan min, TimeSpan max, TimeSpan value2) {
            super(validator, path, value, targetType, message, failLevel);
            this.min = min;
            this.max = max;
            this.value = value2;
        }
    }

    public static class InvalidTimestampException
    extends ValidatorException {
        public final long min;
        public final long max;
        public final long value;

        public InvalidTimestampException(StorableValidator validator, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel, long min, long max, long value2) {
            super(validator, path, value, targetType, message, failLevel);
            this.min = min;
            this.max = max;
            this.value = value2;
        }
    }

    public static class AvailableSinceException
    extends ValidatorException {
        public final long availableSinceTimestamp;

        public AvailableSinceException(StorableValidator validator, long availableSinceTimestamp, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, path, value, targetType, message, failLevel);
            this.availableSinceTimestamp = availableSinceTimestamp;
        }

        @Override
        public String getErrorMessage() {
            if (this.getMessage() != null) {
                return this.getMessage();
            }
            return "Property available since " + DateFormat.getDateTimeInstance(1, 2).format(new Date(this.availableSinceTimestamp)) + "(" + this.availableSinceTimestamp + ")";
        }

        public BuildsInfo.TargetBuildIssue handle(BuildsInfo buildsInfo) {
            Date maximum = buildsInfo.getMaximumBuildDate();
            if (maximum != null && this.availableSinceTimestamp >= maximum.getTime()) {
                return BuildsInfo.TargetBuildIssue.ALL_TARGET_BUILDS_AFFECTED;
            }
            Date minimum = buildsInfo.getMinimumBuildDate();
            if (minimum != null && minimum.getTime() < this.availableSinceTimestamp) {
                return BuildsInfo.TargetBuildIssue.SOME_TARGET_BUILDS_AFFECTED;
            }
            return BuildsInfo.TargetBuildIssue.NO_TARGET_BUILDS_AFFECTED;
        }
    }

    public static class ConditionException
    extends ValidatorException {
        private Condition condition;

        public Condition getCondition() {
            return this.condition;
        }

        public ConditionException(StorableValidator validator, Condition condition, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, path, value, targetType, message, failLevel);
            this.condition = condition;
        }

        public ConditionException(StorableValidator validator, Condition condition, Throwable cause, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, cause, path, value, targetType, message, failLevel);
            this.condition = condition;
        }
    }

    public static class ValidatorException
    extends FlexiMapperException {
        private static final long serialVersionUID = 1L;
        private FailLevel failLevel;
        public final StorableValidator owner;
        public final JSPath path;

        public FailLevel getFailLevel() {
            return this.failLevel;
        }

        public void setFailLevel(FailLevel failLevel) {
            this.failLevel = failLevel;
        }

        public ValidatorException(StorableValidator validator, JSPath path, FlexiJSonNode value, CompiledType targetType, String message) {
            this(validator, path, value, targetType, message, FailLevel.ERROR);
        }

        public ValidatorException(StorableValidator validator, Throwable cause, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(value, targetType, message, cause);
            this.failLevel = failLevel;
            this.owner = validator;
            this.path = path;
        }

        public ValidatorException(StorableValidator validator, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            this(validator, null, path, value, targetType, message, failLevel);
        }

        public String getErrorMessage() {
            return "";
        }

        public String getDetailedMessage() {
            String ret = this.failLevel.name();
            ret = ret + "\r\nJson Node: " + this.path.toPathString(true);
            boolean header = false;
            String add = this.getErrorMessage();
            if (!StringUtils.isNotEmpty(add)) {
                add = this.getClass().getSimpleName();
            }
            if (StringUtils.isNotEmpty(add)) {
                if (!header) {
                    switch (this.failLevel) {
                        case ERROR: {
                            ret = ret + "\r\nError: ";
                            break;
                        }
                        case INFO: {
                            ret = ret + "\r\nInformation: ";
                            break;
                        }
                        case WARNING: {
                            ret = ret + "\r\nWarning: ";
                        }
                    }
                }
                header = true;
                ret = ret + "\r\n" + add;
            }
            if (!StringUtils.isEmpty(this.getMessage()) && !ret.contains(this.getMessage())) {
                if (!header) {
                    switch (this.failLevel) {
                        case ERROR: {
                            ret = ret + "\r\nError: ";
                            break;
                        }
                        case INFO: {
                            ret = ret + "\r\nInformation: ";
                            break;
                        }
                        case WARNING: {
                            ret = ret + "\r\nWarning: ";
                        }
                    }
                    header = true;
                    ret = ret + "" + this.getMessage().replace("] ", "]\r\n");
                } else {
                    ret = ret + "\r\n" + this.getMessage().replace("] ", "]\r\n");
                }
            }
            try {
                final JSPath nodePath = this.node == null ? null : JSPath.fromFlexiNode(this.node);
                FlexiJSonPrettyPrinterForConfig toString = new FlexiJSonPrettyPrinterForConfig(new NodeFilter(){

                    @Override
                    public boolean skipNode(FlexiJSonArray array, int i) {
                        FlexiJSonNode lNode = (FlexiJSonNode)array.get(i);
                        JSPath path = JSPath.fromFlexiNode(lNode);
                        return nodePath != null && !nodePath.startsWith(path);
                    }

                    @Override
                    public boolean skipNode(FlexiJSonObject object, KeyValueElement es) {
                        JSPath path = JSPath.fromFlexiNode(es.getValue());
                        return nodePath != null && !nodePath.startsWith(path);
                    }

                    @Override
                    public boolean skipCommentNode(FlexiComment comment) {
                        JSPath path = JSPath.fromFlexiNode(comment);
                        return nodePath != null && !nodePath.getParent().equals(path.getParent());
                    }
                });
                FlexiJsonMapperForConfig mapper = new FlexiJsonMapperForConfig();
                List<FlexiTypeMapper> customMappers = this.owner.createMapper().getTypeMapper();
                mapper.setTypeMapper(customMappers);
                FlexiJSonNode node = mapper.objectToJsonNode(this.owner.getResult());
                String docs = toString.toJSONString(node);
                if (StringUtils.isNotEmpty(docs)) {
                    ret = ret + "\r\nDocumentation: ";
                    ret = ret + "\r\n" + docs;
                }
            }
            catch (FlexiMapperException e1) {
                e1.printStackTrace();
            }
            return ret;
        }
    }

    public static class UnknownPropertyException
    extends ValidatorException {
        public UnknownPropertyException(StorableValidator validator, JSPath path, FlexiJSonNode value, String message) {
            super(validator, path, value, null, message, FailLevel.WARNING);
        }

        @Override
        public String getErrorMessage() {
            if (this.getMessage() != null) {
                return this.getMessage();
            }
            return "This property name is unknown. Check for type errors!";
        }
    }

    public static class InvalidRegularExpressionException
    extends ValidatorException {
        public InvalidRegularExpressionException(StorableValidator validator, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, path, value, targetType, message, failLevel);
        }
    }

    public static class UnknownEnumException
    extends ValidatorException {
        public final Enum bestGuess;

        public UnknownEnumException(StorableValidator validator, FlexiJSonNode value, CompiledType targetType, Enum bestGuess) {
            super(validator, JSPath.fromFlexiNode(value), value, targetType, null, FailLevel.ERROR);
            this.bestGuess = bestGuess;
        }

        @Override
        public String getErrorMessage() {
            if (this.getMessage() != null) {
                return this.getMessage();
            }
            String ret = "";
            ret = ret + "The value " + new FlexiJSonStringBuilder().toJSONString(this.node) + " is not valid. Please use one of " + StringUtils.join(this.type.raw.getEnumConstants(), "|");
            if (this.bestGuess != null) {
                ret = ret + "\r\nDid you mean \"" + this.bestGuess.name() + "\"?";
            }
            return ret;
        }
    }

    public class AddDefaultsMapper
    extends FlexiJSonMapper {
        @Override
        public <T> T convert(Object obj, TypeRef<T> targetType) throws FlexiMapperException {
            return super.convert(obj, targetType);
        }

        @Override
        protected Object convertStringToNumber(FlexiJSonValue node, String value, CompiledType destType) {
            StorableValidator.this.add(new InvalidTypeException(StorableValidator.this, JSPath.fromFlexiNode(node), node, destType, null, FailLevel.ERROR));
            return super.convertStringToNumber(node, value, destType);
        }

        @Override
        protected Object convertStringToBoolean(FlexiJSonValue node, String value, CompiledType destType) {
            StorableValidator.this.add(new InvalidTypeException(StorableValidator.this, JSPath.fromFlexiNode(node), node, destType, null, FailLevel.ERROR));
            return super.convertStringToBoolean(node, value, destType);
        }

        @Override
        protected Object convertToString(FlexiJSonValue node) {
            StorableValidator.this.add(new InvalidTypeException(StorableValidator.this, JSPath.fromFlexiNode(node), node, CompiledType.STRING, null, FailLevel.ERROR));
            return super.convertToString(node);
        }

        @Override
        protected Object convertNullToBoolean(FlexiJSonValue node) {
            StorableValidator.this.add(new InvalidTypeException(StorableValidator.this, JSPath.fromFlexiNode(node), node, CompiledType.BOOLEAN_PRIMITIVE, null, FailLevel.ERROR));
            return super.convertNullToBoolean(node);
        }

        @Override
        protected Object convertNullToNumber(FlexiJSonValue node, CompiledType destType) {
            StorableValidator.this.add(new InvalidTypeException(StorableValidator.this, JSPath.fromFlexiNode(node), node, destType, null, FailLevel.ERROR));
            return super.convertNullToNumber(node, destType);
        }

        @Override
        protected Enum nodeToEnum(FlexiJSonNode node, CompiledType type) throws FlexiMapperException {
            try {
                return super.nodeToEnum(node, type);
            }
            catch (IllegalArgumentException e) {
                Enum alt = this.findAlternative(node, type.type);
                StorableValidator.this.add(new UnknownEnumException(StorableValidator.this, node, type, alt));
                return alt;
            }
        }

        protected Enum findAlternative(FlexiJSonNode node, Type type) {
            if (node instanceof FlexiJSonValue && ((FlexiJSonValue)node).getValue() != null) {
                int best = Integer.MAX_VALUE;
                String bestmatch = null;
                for (Object en : ReflectionUtils.getRaw(type).getEnumConstants()) {
                    int r = StringUtils.levenshtein(String.valueOf(((FlexiJSonValue)node).getValue()), ((Enum)en).name(), true);
                    if (r >= best) continue;
                    best = r;
                    bestmatch = ((Enum)en).name();
                }
                if (bestmatch == null) {
                    bestmatch = ((Enum)ReflectionUtils.getRaw(type).getEnumConstants()[0]).name();
                }
                try {
                    return Enum.valueOf(ReflectionUtils.getRaw(type), bestmatch);
                }
                catch (Exception e1) {
                    return null;
                }
            }
            try {
                return (Enum)ReflectionUtils.getRaw(type).getEnumConstants()[0];
            }
            catch (Exception e1) {
                return null;
            }
        }

        @Override
        protected void onClassFieldMissing(Object inst, String key, FlexiJSonNode value, CompiledType cc) throws FlexiMapperException {
            StorableValidator.this.add(new UnknownPropertyException(StorableValidator.this, JSPath.fromFlexiNode(value), value, null));
        }
    }

    public class CheckerMapper
    extends AddDefaultsMapper {
        public CheckerMapper() {
            this.setIgnoreIllegalEnumMappings(false);
            this.setIgnoreIllegalArgumentMappings(false);
        }

        @Override
        protected Object createProxy(CompiledType cType, FlexiJSonObject obj) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
            Object ret = super.createProxy(cType, obj);
            return ret;
        }

        @Override
        protected void onClassFieldMissing(Object inst, String key, FlexiJSonNode value, CompiledType cc) throws FlexiMapperException {
            if (cc.getClassCache().getAnnotations(key, StorableValidatorIgnoreKey.class).size() > 0) {
                return;
            }
            if (cc.getClassCache().getAnnotations(key, StorableValidatorIgnoresMissingSetter.class).size() > 0) {
                return;
            }
        }

        @Override
        protected Object returnFallbackOrThrowException(FlexiMapperException ex) throws FlexiMapperException {
            if (ex.getCause() instanceof ClassCastException) {
                String structure = ex.node instanceof FlexiJSonObject ? "Object/Map" : (ex.node instanceof FlexiJSonArray ? "Array/List/Set" : "Number/String/Enum/Boolean/null");
                StorableValidator.this.add(new ValidatorException(StorableValidator.this, ex, JSPath.fromFlexiNode(ex.node), ex.node, ex.type, "Unexpected data structure: '" + structure + "' for target type '" + ex.type.toString(new CompiledType.ToStringRule(CompiledType.ToStringSyntax.JSON)) + "'", FailLevel.ERROR));
            } else {
                StorableValidator.this.add(ex);
            }
            return null;
        }

        @Override
        protected Enum nodeToEnum(FlexiJSonNode node, CompiledType type) throws FlexiMapperException {
            try {
                return super.nodeToEnum(node, type);
            }
            catch (IllegalArgumentException e) {
                Enum alt = this.findAlternative(node, type.type);
                StorableValidator.this.add(new UnknownEnumException(StorableValidator.this, node, type, alt));
                return alt;
            }
        }

        @Override
        public Object jsonToObject(FlexiJSonNode json, CompiledType type, Setter setter) throws FlexiMapperException {
            type = StorableValidator.this.dynamicTypeMapping(json, type, setter);
            Object ret = super.jsonToObject(json, type, setter);
            return ret;
        }

        @Override
        protected void setValueToObject(FlexiJSonNode node, Object inst, CompiledType cType, Object value, Setter setter) throws IllegalAccessException, InvocationTargetException, FlexiMapperException {
            super.setValueToObject(node, inst, cType, value, setter);
        }
    }

    public static class FallbackKeyException
    extends ValidatorException {
        private long deprecatedSinceTimestamp;
        private String correctKey;

        public long getDeprecatedSinceTimestamp() {
            return this.deprecatedSinceTimestamp;
        }

        public String getCorrectKey() {
            return this.correctKey;
        }

        public FallbackKeyException(StorableValidator validator, long deprecatedSince, String correctKey, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, path, value, targetType, message, failLevel);
            this.correctKey = correctKey;
            this.deprecatedSinceTimestamp = deprecatedSince;
        }

        @Override
        public String getErrorMessage() {
            if (this.getMessage() != null) {
                return this.getMessage();
            }
            return "Property deprecated since " + DateFormat.getDateTimeInstance(1, 2).format(new Date(this.deprecatedSinceTimestamp));
        }

        public BuildsInfo.TargetBuildIssue handle(BuildsInfo buildsInfo) {
            Date minimum = buildsInfo.getMinimumBuildDate();
            if (minimum != null && minimum.getTime() < this.deprecatedSinceTimestamp) {
                return BuildsInfo.TargetBuildIssue.ALL_TARGET_BUILDS_AFFECTED;
            }
            Date maximum = buildsInfo.getMaximumBuildDate();
            if (maximum != null && this.deprecatedSinceTimestamp < maximum.getTime()) {
                return BuildsInfo.TargetBuildIssue.SOME_TARGET_BUILDS_AFFECTED;
            }
            return BuildsInfo.TargetBuildIssue.NO_TARGET_BUILDS_AFFECTED;
        }
    }
}

