/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.lang.reflect.InvocationTargetException;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.DeSerializerInput;
import org.appwork.storage.JsonDeSerializer;
import org.appwork.storage.SelfJSONDeSerializer;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.utils.ReflectionUtils;

public class AdapterSelfJSONDeSerializer
implements JsonDeSerializer {
    @Override
    public Object toObject(DeSerializerInput input, TypeRef<?> typeRef, Object mapper) {
        Class<?> raw = ReflectionUtils.getRaw(typeRef.getType());
        if (raw == null && !SelfJSONDeSerializer.class.isAssignableFrom(raw)) {
            return SKIP;
        }
        boolean found = false;
        for (Class<?> intf : raw.getInterfaces()) {
            if (!SelfJSONDeSerializer.class.isAssignableFrom(intf)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new WTFException(raw.getName() + " must implement " + SelfJSONDeSerializer.class.getName() + " properly!");
        }
        try {
            ClassCache cc = ClassCache.getClassCache(raw);
            SelfJSONDeSerializer instance = (SelfJSONDeSerializer)cc.getInstance();
            instance.deserializeFromJSON(input, mapper);
            return instance;
        }
        catch (SecurityException e) {
            throw new WTFException(e);
        }
        catch (NoSuchMethodException e) {
            throw new WTFException(e);
        }
        catch (IllegalArgumentException e) {
            throw new WTFException(e);
        }
        catch (InstantiationException e) {
            throw new WTFException(e);
        }
        catch (IllegalAccessException e) {
            throw new WTFException(e);
        }
        catch (InvocationTargetException e) {
            throw new WTFException(e);
        }
    }
}

