/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.resources.ide;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.resources.IconRef;
import org.appwork.utils.FileHandler;
import org.appwork.utils.Files;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.ide.IDEUtils;
import org.appwork.utils.os.CrossSystem;

public class AWIconCleanUP {
    public static void cleanup(String setup, String global, Class<? extends IconRef> ... classes) throws ClassNotFoundException {
        File project = IDEUtils.getProjectFolder(Class.forName(new Exception().getStackTrace()[1].getClassName()));
        HashSet<String> icons = new HashSet<String>();
        HashMap<String, HashSet<Class<? extends IconRef>>> clsMap = new HashMap<String, HashSet<Class<? extends IconRef>>>();
        for (Class<? extends IconRef> cl : classes) {
            for (IconRef e : cl.getEnumConstants()) {
                icons.add(e.path());
                System.out.println(cl.getSimpleName() + "." + e + " - " + e.path());
                HashSet<Class<? extends IconRef>> ls = (HashSet<Class<? extends IconRef>>)clsMap.get(e.path());
                if (ls == null) {
                    ls = new HashSet<Class<? extends IconRef>>();
                    clsMap.put(e.path(), ls);
                }
                ls.add(cl);
            }
        }
        for (String icon : icons) {
            File pngThemes = new File(new File(project, setup), icon + ".png");
            File svgThemes = new File(new File(project, setup), icon + ".svg");
            File pngglobal = new File(new File(project, global), icon + ".png");
            File svgglobal = new File(new File(project, global), icon + ".svg");
            if (!(CrossSystem.caseSensitiveFileExists(pngglobal) || CrossSystem.caseSensitiveFileExists(svgglobal) || CrossSystem.caseSensitiveFileExists(pngThemes) || CrossSystem.caseSensitiveFileExists(svgThemes))) {
                System.err.println("Missing Icon!: " + icon + " " + clsMap.get(icon));
                continue;
            }
            System.out.println("OK icon: " + icon);
        }
        AWIconCleanUP.findUnused(icons, new File(project, setup));
    }

    private static void findUnused(final HashSet<String> icons, final File root) {
        Files.walkThroughStructure(new FileHandler<RuntimeException>(){

            @Override
            public void intro(File f) throws RuntimeException {
            }

            @Override
            public boolean onFile(File f, int depths) throws RuntimeException {
                String rel = Files.getRelativePath(root, f);
                if (StringUtils.isNotEmpty(rel = rel.replace("\\", "/")) && (rel.endsWith(".svg") || rel.endsWith(".png")) && !icons.contains(rel = rel.replaceAll("\\.(png|svg)$", ""))) {
                    System.err.println("Useless Icon: " + f + " ( " + rel + " ) ");
                }
                return true;
            }

            @Override
            public void outro(File f) throws RuntimeException {
            }
        }, root);
    }

    public static void printIconRefClassesInClassPath() {
        final StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append("  ArrayList<Class<? extends IconRef>> required = new ArrayList<Class<? extends IconRef>>();");
        try {
            Enumeration<URL> roots = AWIconCleanUP.class.getClassLoader().getResources("");
            while (roots.hasMoreElements()) {
                File folder;
                URL u = roots.nextElement();
                if (!u.getProtocol().equals("file") || !(folder = new File(u.getPath())).isDirectory()) continue;
                sb.append("\r\n").append("// in " + folder.getParentFile().getName());
                Files.walkThroughStructure(new FileHandler<RuntimeException>(){

                    @Override
                    public void intro(File f) throws RuntimeException {
                    }

                    @Override
                    public boolean onFile(File f, int depths) throws RuntimeException {
                        String path;
                        if ("class".equals(Files.getExtension(f.getName())) && !(path = new Regex(Files.getRelativePath(folder, f), "(.*)\\.class$").getMatch(0).replace("/", ".")).contains("$") && path.toLowerCase(Locale.ENGLISH).contains("icon")) {
                            try {
                                Class<?> cls = Class.forName(path);
                                if (IconRef.class.isAssignableFrom(cls) && cls.isEnum()) {
                                    sb.append("\r\n").append("\trequired.add(" + path + ".class);");
                                }
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                        return true;
                    }

                    @Override
                    public void outro(File f) throws RuntimeException {
                    }
                }, folder);
            }
            System.out.println(sb);
        }
        catch (IOException e1) {
            throw new WTFException(e1);
        }
    }
}

