/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.remoteapi.InterfaceHandler;
import org.appwork.remoteapi.exceptions.ApiCommandNotAvailable;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.net.HeaderCollection;
import org.appwork.utils.net.httpserver.requests.ConnectRequest;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HeadRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequestInterface;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.OptionsRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;

public class RemoteAPIRequest
implements HttpRequestInterface {
    private final InterfaceHandler<?> iface;
    private final String[] parameters;
    protected final HttpRequest request;
    private final Method method;
    private final String jqueryCallback;
    private final String methodName;

    public String toString() {
        return this.request + "\r\nMethod: " + this.method + "\r\nParameters:" + JSonStorage.serializeToJson(this.parameters);
    }

    public RemoteAPIRequest(InterfaceHandler<?> iface, String methodName, String[] parameters, HttpRequest request, String jqueryCallback) throws BasicRemoteAPIException {
        this.iface = iface;
        this.parameters = parameters;
        this.request = request;
        this.methodName = methodName;
        this.jqueryCallback = jqueryCallback;
        this.method = this.iface.getMethod(methodName, this.parameters.length);
        if (this.method == null) {
            LogV3.info("IP " + request.getRemoteAddress());
            if (this.iface.hasMethodName(methodName)) {
                throw new BadParameterException(request.getRequestedURL());
            }
            throw new ApiCommandNotAvailable(request.getRequestedURL());
        }
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public InterfaceHandler<?> getIface() {
        return this.iface;
    }

    public InputStream getInputStream() throws IOException {
        if (this.request instanceof PostRequest) {
            return ((PostRequest)this.request).getInputStream();
        }
        return null;
    }

    public String getJqueryCallback() {
        return this.jqueryCallback;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getParameterbyKey(String key) throws IOException {
        if (this.request != null) {
            return this.request.getParameterbyKey(key);
        }
        return null;
    }

    @Override
    public String[] getParametersbyKey(String key) throws IOException {
        if (this.request != null) {
            return this.request.getParametersbyKey(key);
        }
        return null;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public List<String> getRemoteAddresses() {
        return this.request.getRemoteAddress();
    }

    public String getRemoteAddress() {
        return this.request.getActuallRemoteAddress();
    }

    @Override
    public String getRequestedPath() {
        return this.request.getRequestedPath();
    }

    @Override
    public String getRequestedURL() {
        return this.request.getRequestedURL();
    }

    @Override
    public List<KeyValuePair> getRequestedURLParameters() {
        return this.request.getRequestedURLParameters();
    }

    @Override
    public HeaderCollection getRequestHeaders() {
        return this.request.getRequestHeaders();
    }

    public long getRequestID() {
        return -1L;
    }

    public REQUESTTYPE getRequestType() {
        if (this.request instanceof OptionsRequest) {
            return REQUESTTYPE.OPTIONS;
        }
        if (this.request instanceof HeadRequest) {
            return REQUESTTYPE.HEAD;
        }
        if (this.request instanceof PostRequest) {
            return REQUESTTYPE.POST;
        }
        if (this.request instanceof GetRequest) {
            return REQUESTTYPE.GET;
        }
        if (this.request instanceof ConnectRequest) {
            return REQUESTTYPE.CONNECT;
        }
        return REQUESTTYPE.UNKNOWN;
    }

    public String getSignature() {
        return null;
    }

    public boolean validateRID() {
        return true;
    }

    public boolean isHttps() {
        return this.request.isHttps();
    }

    @Override
    public long getId() {
        return this.request.getId();
    }

    public static enum REQUESTTYPE {
        CONNECT,
        HEAD,
        POST,
        OPTIONS,
        GET,
        UNKNOWN;

    }
}

