/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Locale;
import org.appwork.loggingv3.LogV3Factory;
import org.appwork.loggingv3.LogV3FactoryImpl;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.LogVetoListener;
import org.appwork.loggingv3.simple.SimpleLoggerFactory;
import org.appwork.loggingv3.simple.sink.Sink;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.NullOutputStream;

public class LogV3 {
    private static LogV3Factory INSTANCE;

    public static LogV3Factory I() {
        if (INSTANCE == null) {
            LogV3.setFactory(new LogV3FactoryImpl());
        }
        return INSTANCE;
    }

    private static LogV3Factory createInstance() {
        String load = LogV3FactoryImpl.class.getName();
        try {
            load = LogV3.class.getPackage().getName() + ".simple.SimpleLoggerFactory";
            Class.forName(load);
        }
        catch (Throwable e) {
            load = LogV3FactoryImpl.class.getName();
        }
        try {
            String clazz = System.getProperty("org.appwork.LoggerFactory", load);
            LogV3Factory ret = (LogV3Factory)Class.forName(clazz).newInstance();
            try {
                Method initDefaults = ret.getClass().getMethod("initDefaults", new Class[0]);
                initDefaults.invoke((Object)ret, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return ret;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error Initialising Logging facade", e);
        }
    }

    public static void log(Throwable t) {
        LogV3.I().getDefaultLogger().log(t);
    }

    public static void info(String string) {
        LogV3.I().getDefaultLogger().info(string);
    }

    public static void severe(String string) {
        LogV3.I().getDefaultLogger().severe(string);
    }

    public static void warning(String string) {
        LogV3.I().getDefaultLogger().warning(string);
    }

    public static void finest(String string) {
        LogV3.I().getDefaultLogger().finest(string);
    }

    public static void finer(String string) {
        LogV3.I().getDefaultLogger().finer(string);
    }

    public static void fine(String string) {
        LogV3.I().getDefaultLogger().fine(string);
    }

    public static LogInterface defaultLogger() {
        return LogV3.I().getDefaultLogger();
    }

    public static LogInterface logger(Object name) {
        return LogV3.I().getLogger(name);
    }

    public static void setFactory(LogV3Factory instance) {
        INSTANCE = instance == null ? null : instance.setFactory(INSTANCE);
    }

    public static LogV3Factory getFactory() {
        return INSTANCE;
    }

    public static void disableSysout() {
        LogV3Factory logFactory = LogV3.getFactory();
        if (logFactory != null && logFactory instanceof SimpleLoggerFactory) {
            ((SimpleLoggerFactory)logFactory).addVetoListener(new LogVetoListener(){

                @Override
                public boolean blockLogPublishing(SimpleLoggerFactory simpleLoggerFactory, Sink sink, LogRecord2 record) {
                    return true;
                }
            });
        }
        PrintStream nullStream = new PrintStream(new NullOutputStream()){

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b) {
            }

            @Override
            public void write(byte[] buf, int off, int len) {
            }

            @Override
            public void print(boolean b) {
            }

            @Override
            public void print(char c) {
            }

            @Override
            public void print(int i) {
            }

            @Override
            public void print(long l) {
            }

            @Override
            public void print(float f) {
            }

            @Override
            public void print(double d) {
            }

            @Override
            public void print(char[] s) {
            }

            @Override
            public void print(String s) {
            }

            @Override
            public void print(Object obj) {
            }

            @Override
            public void println() {
            }

            @Override
            public void println(boolean x) {
            }

            @Override
            public void println(char x) {
            }

            @Override
            public void println(int x) {
            }

            @Override
            public void println(long x) {
            }

            @Override
            public void println(float x) {
            }

            @Override
            public void println(double x) {
            }

            @Override
            public void println(char[] x) {
            }

            @Override
            public void println(String x) {
            }

            @Override
            public void println(Object x) {
            }

            @Override
            public PrintStream printf(String format, Object ... args) {
                return this;
            }

            @Override
            public PrintStream printf(Locale l, String format, Object ... args) {
                return this;
            }

            @Override
            public PrintStream format(String format, Object ... args) {
                return this;
            }

            @Override
            public PrintStream format(Locale l, String format, Object ... args) {
                return this;
            }

            @Override
            public PrintStream append(CharSequence csq) {
                return this;
            }

            @Override
            public PrintStream append(CharSequence csq, int start, int end) {
                return this;
            }

            @Override
            public PrintStream append(char c) {
                return this;
            }
        };
        System.setOut(nullStream);
        System.setErr(nullStream);
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LogV3.logger(t).exception("Uncaught Exception in: " + t.getId() + "=" + t.getName(), e);
            }
        });
        INSTANCE = LogV3.createInstance();
    }
}

