/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.streams.signature;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Mac;
import org.appwork.exceptions.WTFException;
import org.appwork.io.streams.signature.DigestInterface;
import org.appwork.io.streams.signature.DigesterOutputStream;
import org.appwork.io.streams.signature.HoldBackInputStream;
import org.appwork.io.streams.signature.MacDigester;
import org.appwork.io.streams.signature.MessageDigester;
import org.appwork.io.streams.signature.SignatureMismatchException;
import org.appwork.io.streams.signature.StreamEndedUnexpectedException;
import org.appwork.io.streams.signature.StreamSignatureCreatingOutputStream;
import org.appwork.utils.IO;

public class HandleStreamSignatureInputStream
extends InputStream {
    private DigestInterface digester;
    private long remainingPayloadSize = 0L;
    private long payloadBytesRead = 0L;
    private byte[] nonceBytes;
    private byte[] calculatedSignature;
    private long lastValidPayloadPosition;
    private final byte[] single = new byte[1];
    private HoldBackInputStream in;
    private final int signatureLength;
    private final byte[] expectedSignature;
    private long streamVersion = -1L;
    private DataInputStream dataIn;
    private boolean closed;
    private DataOutputStream digesterStream;

    public HandleStreamSignatureInputStream(InputStream is, MessageDigest digest, byte[] nonceBytes) {
        this(is, new MessageDigester(digest), nonceBytes);
    }

    public HandleStreamSignatureInputStream(InputStream is, Mac mac, byte[] nonceBytes) {
        this(is, new MacDigester(mac), nonceBytes);
    }

    public HandleStreamSignatureInputStream(InputStream is, DigestInterface digester, byte[] nonceBytes) {
        this.signatureLength = digester.getLength();
        this.in = new HoldBackInputStream(is, this.signatureLength, 1);
        this.dataIn = new DataInputStream(this.in);
        this.expectedSignature = new byte[this.signatureLength];
        this.digester = digester;
        this.digesterStream = new DataOutputStream(new DigesterOutputStream(digester));
        this.nonceBytes = nonceBytes;
    }

    protected void initChunkDigester(long chunkSize) throws IOException {
        StreamSignatureCreatingOutputStream.initChunkDigesterStatic(this.digesterStream, this.streamVersion, chunkSize, this.nonceBytes, this.calculatedSignature);
    }

    @Override
    public int read() throws IOException {
        int ret;
        while ((ret = this.internalRead(this.single, 0, 1)) == 0) {
        }
        if (ret < 0) {
            return -1;
        }
        return this.single[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.internalRead(b, off, len);
    }

    public long readVersionNumber() throws IOException {
        if (this.streamVersion < 0L) {
            this.read(new byte[0]);
        }
        return this.streamVersion;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private final int internalRead(byte[] b, int off, int len) throws IOException, UnsupportedEncodingException, SignatureMismatchException {
        int toRead;
        int actuallyRead;
        if (this.closed) {
            return -1;
        }
        if (this.in.getTail() != null) {
            this.closed = true;
            return -1;
        }
        if (this.in.getPayloadBytesLoaded() == 0L) {
            this.streamVersion = this.readHeader();
            if (this.streamVersion != 1L) {
                throw new IOException("Unknown Streamversion");
            }
        }
        if (this.remainingPayloadSize == 0L) {
            this.remainingPayloadSize = this.readNextPayloadBlockSize();
            this.initChunkDigester(this.remainingPayloadSize);
        }
        if ((actuallyRead = this.in.read(b, off, toRead = (int)Math.min(this.remainingPayloadSize, (long)len))) >= 0) {
            this.remainingPayloadSize -= (long)actuallyRead;
            this.payloadBytesRead += (long)actuallyRead;
            this.digesterStream.write(b, off, actuallyRead);
        }
        if (this.in.getTail() != null) {
            byte[] tail = this.in.getTail();
            if (len == 0) {
                throw new WTFException("not possible here");
            }
            this.validateSignature(tail, true);
        } else if (this.remainingPayloadSize == 0L) {
            int n = 0;
            boolean tail = false;
            while (n < this.expectedSignature.length) {
                int count = this.in.read(this.expectedSignature, n, this.expectedSignature.length - n);
                if (count < 0) {
                    if (n == 0) {
                        if (this.in.getTail() == null || this.in.getTail().length != this.expectedSignature.length) {
                            throw new WTFException("Invalid Tail");
                        }
                        tail = true;
                        System.arraycopy(this.in.getTail(), 0, this.expectedSignature, 0, this.expectedSignature.length);
                        n = this.expectedSignature.length;
                        continue;
                    }
                    throw new EOFException("Unexpected End Of Stream");
                }
                n += count;
            }
            this.validateSignature(this.expectedSignature, tail);
            if (!tail && this.in.getTail() != null) {
                throw new EOFException("Unexpected End Of Stream");
            }
        }
        if (actuallyRead < 0) {
            this.closed = true;
        }
        return actuallyRead;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void validateSignature(byte[] tail, boolean eof) throws SignatureMismatchException, StreamEndedUnexpectedException {
        if (eof) {
            DigestInterface cloneBeforeEndSalt = null;
            if (this.remainingPayloadSize == 0L) {
                try {
                    cloneBeforeEndSalt = this.digester.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            this.digester.update(StreamSignatureCreatingOutputStream.END_SIGNATURE_SALT);
            this.calculatedSignature = this.digester.doFinal();
            if (!Arrays.equals(tail, this.calculatedSignature)) {
                if (cloneBeforeEndSalt != null && Arrays.equals(tail, cloneBeforeEndSalt.doFinal())) {
                    this.lastValidPayloadPosition = this.payloadBytesRead;
                    throw new StreamEndedUnexpectedException();
                }
                throw new SignatureMismatchException();
            }
            this.lastValidPayloadPosition = this.payloadBytesRead;
        } else {
            this.calculatedSignature = this.digester.doFinal();
            if (!Arrays.equals(tail, this.calculatedSignature)) {
                throw new SignatureMismatchException();
            }
            this.lastValidPayloadPosition = this.payloadBytesRead;
        }
    }

    protected long readHeader() throws IOException {
        return IO.readLongOptimized(this.in);
    }

    public long getStreamVersion() {
        return this.streamVersion;
    }

    protected long readNextPayloadBlockSize() throws IOException {
        return IO.readLongOptimized(this.in);
    }

    public long getLastValidPayloadPosition() {
        return this.lastValidPayloadPosition;
    }

    public long getPayloadBytesLoaded() {
        return this.payloadBytesRead;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.in.close();
    }

    @Override
    public long skip(long n) throws IOException {
        int ret;
        if (n <= 0L) {
            return 0L;
        }
        long remaining = n;
        byte[] buff = new byte[2000];
        while (n > 0L && (ret = this.internalRead(buff, 0, (int)Math.min((long)buff.length, remaining))) >= 0) {
            remaining -= (long)ret;
        }
        return n - remaining;
    }

    public long getBytesLoadedAndValidated() {
        return this.lastValidPayloadPosition;
    }
}

