/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.app.launcher.parameterparser;

import java.util.ArrayList;
import org.appwork.utils.StringUtils;

public class CommandSwitch {
    private String[] parameters;
    private final String caseInsensitiveSwitchCommand;
    private final String caseSensitiveSwitchCommand;

    public CommandSwitch(String switchCommand, String[] array) {
        this.caseInsensitiveSwitchCommand = StringUtils.toLowerCaseOrNull(switchCommand);
        this.caseSensitiveSwitchCommand = switchCommand;
        this.parameters = array;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-");
        sb.append(this.getCaseInsensitiveSwitchCommand());
        for (String p : this.getParameters()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("\"");
            sb.append(p);
            sb.append("\"");
        }
        return sb.toString();
    }

    public String[] getParameters() {
        return this.parameters;
    }

    @Deprecated
    public String getSwitchCommand() {
        return this.getCaseInsensitiveSwitchCommand();
    }

    public String getCaseInsensitiveSwitchCommand() {
        return this.caseInsensitiveSwitchCommand;
    }

    public String getCaseSensitiveSwitchCommand() {
        return this.caseSensitiveSwitchCommand;
    }

    public boolean hasAnyParameter(String ... strings) {
        for (String search : strings) {
            for (String param : this.getParameters()) {
                if (!StringUtils.equals(search, param)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasParameter(String string) {
        for (String p : this.getParameters()) {
            if (!p.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyParameterIgnoreCase(String ... strings) {
        for (String search : strings) {
            for (String param : this.getParameters()) {
                if (!StringUtils.equalsIgnoreCase(search, param)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean removeAll(String ... searches) {
        String[] params;
        boolean ret = false;
        ArrayList<String> newList = new ArrayList<String>();
        block0: for (String next : params = this.getParameters()) {
            for (String search : searches) {
                if (!StringUtils.equals(next, search)) continue;
                ret = true;
                continue block0;
            }
            newList.add(next);
        }
        if (ret) {
            this.parameters = newList.toArray(new String[0]);
        }
        return ret;
    }

    public boolean removeAllIgnoreCase(String ... searches) {
        String[] params;
        boolean ret = false;
        ArrayList<String> newList = new ArrayList<String>();
        block0: for (String next : params = this.getParameters()) {
            for (String search : searches) {
                if (!StringUtils.equalsIgnoreCase(next, search)) continue;
                ret = true;
                continue block0;
            }
            newList.add(next);
        }
        if (ret) {
            this.parameters = newList.toArray(new String[0]);
        }
        return ret;
    }
}

